//Error rate performance of BPSK modulated signal over only AWGN channel and AWGN and Rayleigh channel both
clc;
clear;
xdel(winsid());
sym=10000;//No .of symbols
data1=grand(1,sym,"uin",0,1);//Randomly generated Symbolsfrom 0 to 1with uniform distribution

bpsk_mod=2*data1-1;//BPSK Modulation
snr=1:20;//signal to Noise Ratio
    for k=1:1:length(snr)
        
        H1=1/sqrt(2)*(rand(1,length(bpsk_mod),'normal')+%i*(rand(1,length(bpsk_mod),'normal')));//Rayleigh fading generation
       
        noise=1/sqrt(2)*(10^(-(k/20)))*(rand(1,length(bpsk_mod),'normal')+%i*(rand(1,length(bpsk_mod),'normal')));// White Gaussian Noise generation
               
               rec1_bpsk=bpsk_mod+noise;//BPSK modulated signal over AWGN channel 
               rec1_bpsk_ray1= H1.*bpsk_mod+noise;//BPSK modulated signal over AWGN channel and Rayleigh Fading channel
              rec1_bpsk_ray=conj(H1).*rec1_bpsk_ray1;//multiplication with conjugate of rayleigh fading to nullify phase because of Rayleigh Fading
             //  rec1_bpsk_ray=rec1_bpsk_ray1./(H1.*conj(H1));
                            
               rec_data_bpsk=[];rec_ray_bpsk=[];
               
        for i=1:1:length(data1)//BPSK Demodulation of received signal over AWGN channel
            if real(rec1_bpsk(i))>=0 
                 demod_out_bpsk=1;
            else real(rec1_bpsk(i))<0
                demod_out_bpsk=0;                
            end
            rec_data_bpsk=[rec_data_bpsk demod_out_bpsk];//Received signal 
            
            if real(rec1_bpsk_ray(i))>=0 //BPSK Demodulation of received signal over AWGN channel and Rayleigh channel
                 demod_ray_bpsk=1;
            else real(rec1_bpsk_ray(i))<0
                demod_ray_bpsk=0;                
            end
            rec_ray_bpsk=[rec_ray_bpsk demod_ray_bpsk];////Received signal 
        end
       
        errB=0;errC=0;
    for i=1:sym
              
        if rec_data_bpsk(i)==data1(i)//Error rate calculation of received signal by considering only AWGN Channel
            errB=errB;
        else
            errB=errB+1;
        end
    
        BER_bpsk(k)=errB/sym;//BER at receiver by considering only AWGN Channel
        
         if rec_ray_bpsk(i)==data1(i)//Error rate calculation of received signal by considering AWGN Channel and Rayleigh channel
            errC=errC;
        else
            errC=errC+1;
        end
    
        BER_bpsk_ray(k)=errC/sym;//BER at receiver by considering AWGN Channel and rayleigh channel
    end  end
        
       // end
snr=1:1:20;
plot2d(snr,BER_bpsk,5,logflag="nl");
plot2d(snr,BER_bpsk_ray,3,logflag="nl");
mtlb_axis([0 20 10^-5 0.5]);
xgrid(10);
xtitle( 'Bit Error Rate plot for BPSK modulated signal over AWGN channel and AWGN and Rayleigh channel both', 'SNR', 'BER') ;
legend(['BER_BPSK_AWGN';'BER_BPSK_AWGN & Rayleigh']);
//This experiment results plot of error rate performance of BPSK modulated signal over AWGN channe and AWGN and Rayleigh channel both.
//This experiment will take some time to display plot as higher no. of bits entered as an input to get better plots.



